package gov.va.med.mhv.rxrefill.web.form.bean;

import gov.va.med.mhv.health.dto.AllergyDTO;
import gov.va.med.mhv.health.enums.DiagnosedEnumeration;
import gov.va.med.mhv.health.enums.SeverityEnumeration;
import gov.va.med.mhv.health.util.CommonUtility;

public class Allergy extends AllergyDTO{
	
	private static final long serialVersionUID = 8026225259728108944L;
	
	public String getDisplayEventDate() {
		return  CommonUtility.dateToString(getEventDate(), "MM/dd/yyyy");
	}
	
	public String getDisplaySeverity(){
    	String severity=null;
    	if(getSeverity() != null){
    		severity=SeverityEnumeration.valueOf(getSeverity()).getDescription();
    	}
    	return severity;
	}
	
	public String getDisplayDiagnosed(){
    	String diagnosed=null;
    	if(getDiagnosed() != null){
    		diagnosed=DiagnosedEnumeration.valueOf(getDiagnosed()).getDescription();
    	}
    	return diagnosed;
	}
	
	public String getDashboardDate() {
		return  CommonUtility.dateToString(getEventDate(), "EEE MM/dd/yyyy");
	}


}
